///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"

#include "../../SharedClasses/CCmdLine/CCmdLine.H"

#include "Entry.H"
#include "Init.H"
#include "Routines.H"
#include "WinService.H"
#include "Console.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsRegistryKey[255];
char gsEventName[255];

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessCommandLine(CCmdLine *lpCmd);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR sCmdLine, int iCmdShow)
//int main(void)
{
	int iReturnVal = 0;

	ghAppInstance = hInstance;
	//ghAppInstance = GetModuleHandle(NULL);

	if(IsWinNT() != true)
	{
		MessageBox(NULL, "This application was designed to run only on NT based systems.", "SQL Exchange", MB_ICONASTERISK | MB_SYSTEMMODAL | MB_TASKMODAL);
		return 2;
	}

	gbExcludeInit = ExcludedFromInit(sCmdLine);

	if(!InitializeApp())
    {
        return 1;
    }
	
	if(strlen(sCmdLine) > 0)
	{
		CCmdLine MyCmd;

		if(MyCmd.Alloc())
		{
			iReturnVal = ProcessCommandLine(&MyCmd);
		}

		MyCmd.Free();
	}
	else{
		iReturnVal = StartRoutine("/NonService");
	}

	if(!UninitializeApp())
    {
        return 1;
    }

	return iReturnVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessCommandLine(CCmdLine *lpCmd)
{
	int iArg = 0;
	int iArgSz = 0;
	char *sArg = NULL;
	char *sMsg = NULL;

	while(iArg < lpCmd->iCount)
	{
		sArg = "/AutoConnect";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			gbAutoConnect = true;
		}

		sArg = "/Account:";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			GetFlagedValue(lpCmd->sArray[iArg], iArgSz, lpCmd->iLen[iArg], gsCompanyName);
		}

		sArg = "/Password:";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			GetFlagedValue(lpCmd->sArray[iArg], iArgSz, lpCmd->iLen[iArg], gsCompanyPassword);
		}

		sArg = "/SQLDriver:";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			GetFlagedValue(lpCmd->sArray[iArg], iArgSz, lpCmd->iLen[iArg], gsSQLDriver);
		}

		sArg = "/SQLPassword:";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			GetFlagedValue(lpCmd->sArray[iArg], iArgSz, lpCmd->iLen[iArg], gsSQLPassword);
		}

		sArg = "/SQLServer:";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			GetFlagedValue(lpCmd->sArray[iArg], iArgSz, lpCmd->iLen[iArg], gsSQLServer);
		}

		sArg = "/SQLUserID:";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			GetFlagedValue(lpCmd->sArray[iArg], iArgSz, lpCmd->iLen[iArg], gsSQLUserID);
		}

		sArg = "/NonService";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			if(IsApplicationRunning())
			{
				return 0;
			}
			return StartRoutine(sArg);
		}

		sArg = "/RunService";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			if(IsApplicationRunning())
			{
				return 0;
			}
			return StartRoutine(sArg);
		}

		sArg = "/OpenConsole";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			if(IsApplicationRunning())
			{
				return 0;
			}

   			if( IsServiceInstalled() == _No_ )
   			{
       			MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
   				return 0;
			}

			if(IsServiceActive() == _No_)
			{
				if(MessageBox(NULL, "The service is not started. Would you like to start it now?", gsTitleCaption, MB_YESNO|MB_TASKMODAL|MB_ICONQUESTION) == IDNO)
				{
					return 0;
				}

    			if(StartService() == _Success_)
				{
		    		//MessageBox(NULL, "The service was started sucessfully.", gsTitleCaption, MB_ICONINFORMATION);
				}
				else{
        			if(IsClientConfigured(false))
					{
						MessageBox(NULL, "Failed to start the service.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
					}
       				return 0;
				}
			}

			if(TriggerEvent(OpenServerConsoleEventName) != _Success_)
			{
				MessageBox(NULL, "Failed to modify service event state.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
			}

			return 0;
		}

		sArg = "/OpenMainDialog";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{

   			if( IsServiceInstalled() == _No_ )
   			{
       			MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
   				return 0;
			}

			if(IsServiceActive() == _No_)
			{
				if(IsApplicationRunning())
				{
					return 0;
				}

				if(MessageBox(NULL, "The service is not started. Would you like to start it now?", gsTitleCaption, MB_YESNO|MB_TASKMODAL|MB_ICONQUESTION) == IDNO)
				{
					return 0;
				}

    			if(StartService() == _Success_)
				{
		//    		MessageBox(NULL, "The service was started sucessfully.", gsTitleCaption, MB_ICONINFORMATION );
				}
				else{
        			MessageBox(NULL, "Failed to start the service.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
       				return 0;
				}
			}

			if(TriggerEvent(OpenMainDialogEventName) != _Success_)
			{
				MessageBox(NULL, "Failed to modify service event state.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
			}

			return 0;
		}

		sArg = "/Install";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			char Application[257];
			char sSrvcCmdLine[MAX_PATH];

    		short ServiceInstalled = IsServiceInstalled();

			if( ServiceInstalled == _Yes_ )
			{
    			//MessageBox(NULL, "The service is already installed.", gsTitleCaption, MB_ICONINFORMATION );
				return 0;
			}

			GetModuleFileName(ghAppInstance, Application, MAX_PATH);

			sprintf_s(sSrvcCmdLine, sizeof(sSrvcCmdLine), "%s /RunService", Application);

			if ( InstallService(sSrvcCmdLine) == _Success_ )
			{
				SetServiceDescription("Provides secure high performance database replication over TCP/IP.");
				//MessageBox(NULL, "The service was installed sucessfully.", gsTitleCaption, MB_ICONINFORMATION );
				return 0;
			}
			else{
				MessageBox(NULL, "Failed to install the service.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}

			return 0;
		}

		sArg = "/Start";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			if(IsApplicationRunning())
			{
				return 0;
			}

			if( IsServiceInstalled() == _No_ )
			{
    			MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}

			if(IsServiceActive() == _Yes_)
			{
	//    		MessageBox(NULL, "The service is already active.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}

			if(StartService() == _Success_)
			{
	//    		MessageBox(NULL, "The service was started sucessfully.", gsTitleCaption, MB_ICONINFORMATION);
				return 0;
			}
			else{
    			MessageBox(NULL, "Failed to start the service.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
   				return 0;
			}

			return 0;
		}

		sArg = "/Delete";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			if( IsServiceInstalled() == _No_ )
			{
	//    		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_ICONINFORMATION );
				return 0;
			}

			if(IsServiceActive() == _Yes_)
			{
				CommandService(SERVICE_CONTROL_STOP); // Failure would not be an error.
				return 0;
			}

    		if( UninstallService() == _Success_ )
    		{
	//    		MessageBox(NULL, "The service was marked for deletion.", gsTitleCaption, MB_ICONINFORMATION);
    			return 0;
       		}
			else{
    			MessageBox(NULL, "Failed to mark the service for deletion.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}

			return 0;
		}

		sArg = "/Stop";
		iArgSz = strlen(sArg);
		if(_strnicmp(lpCmd->sArray[iArg], sArg, iArgSz) == 0)
		{
			if( IsServiceInstalled() == _No_ )
			{
	//    		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}

			if(IsServiceActive() == _No_)
			{
	//    		MessageBox(NULL, "The service is already stopped.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}

    		if( CommandService(SERVICE_CONTROL_STOP) == _Success_ )
    		{
	//    		MessageBox(NULL, "The service was stopped.", gsTitleCaption, MB_ICONINFORMATION );
    			return 0;
       		}
			else{
    			MessageBox(NULL, "Failed to stop the service.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
				return 0;
			}
			return 0;
		}

		iArg++;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int StartRoutine(char *sCmdLine)
{
	HANDLE MutexHandle = NULL;

	SECURITY_DESCRIPTOR SD;
	SECURITY_ATTRIBUTES SA;

	if(InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION) == FALSE)
		return _Error_;

	if(SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE) == FALSE)
		return _Error_;

	SA.nLength				= sizeof(SA);
	SA.lpSecurityDescriptor = &SD;
	SA.bInheritHandle		= FALSE;

	char sMutexName[1024];
	if((MutexHandle = CreateMutex(&SA, FALSE, GetBuildMutexName(gsTitleCaption, sizeof(sMutexName), sMutexName))) != NULL)
	{
		if(GetLastError() == ERROR_ALREADY_EXISTS)
		{
			MessageBox(NULL, "Application already running.", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
			WriteSysLogEx("Application already running.", EVENT_ERROR);
			return _Error_;
		}
	}

	if(_strcmpi(sCmdLine, "/RunService") == 0)
	{
		int Length = 0;
		short Result = 0;

		gbRunningAsService = true;

		//-------------------------------------------------------------------------------

		Result = ServiceEntry();

		if(Result == _Success_)
		{
			return(_Success_);
		}
		else if(Result == _Error_)
		{
			return(_Error_);
		}
	}
	else{
		if(_strcmpi(sCmdLine, "/NonService") == 0)
		{
			gbRunningAsService = false;
			hServiceThread_Handle = CreateThread(NULL ,0, ServiceThread,(LPVOID)0, 0, &dwServiceThread_ID);
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), 0, (DLGPROC)MainDialog);
			WaitOnApplicationToExit();
			return _Success_;
		}
	}
	return _Error_;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool MainEntry(void)
{
    gbApplicationRunning = true;

	WriteSysLogEx("Client started.", EVENT_INFO);

	if(!gServer.Start())
	{
		WriteSysLogEx("Failed to start the client.", EVENT_ERROR);
		gbApplicationRunning = false;
		return false;
	}

	Timer_Thread_Handle = CreateThread(NULL, 0, Timer_Thread, (LPVOID)0, 0, &Timer_Thread_ID);

	int iStatCount = 10000;

	while(!gbKillApplication)
    {
    	if(WaitForSingleObject(hOpenMainDialog_Handle, 0) == WAIT_OBJECT_0)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)MainDialog);
        }

    	if(WaitForSingleObject(hOpenConsole_Handle, 0) == WAIT_OBJECT_0)
        {
			//Not implemented.
        }

		if(iStatCount > 1000)
		{
			UpdateStatistics();
			iStatCount = 0;
		}

		iStatCount++;

		Sleep(1);
    }
	WriteSysLogEx("Client Stopped.", EVENT_INFO);

    if(!gServer.Stop())
	{
		WriteSysLogEx("Failed to stop the client.", EVENT_ERROR);
	    gbApplicationRunning = false;
		return false;
	}

	gbApplicationRunning = false;
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif

